/***************************************************
  Based on L3G4200D Tripple Axis Gyroscope + Arduino
  Wednesday, June 15 th , 2011 from Adam Meyer
  http://bildr.org/2011/06/l3g4200d-arduino/

  Which in part is based on code by Jim Lindblom
  SparkFun Electronics (https://www.sparkfun.com/products/10612)
  date: 4/18/11
  license: CC-SA 3.0 - Use this code however you'd like, all we ask
  for is attribution. And let us know if you've improved anything! 
 ****************************************************/
 
/**************************************************************************
 Modifications were only made for integration and reducing firmware 
 footprint
 F.J. Kraan, fjkraan@xs4all.nl. 2013-12-28
***************************************************************************/

#ifndef L3G4200D_h
#define L3G4200D_h

#include "generic.h"

//I2C address of the L3G4200D
#define L3G4200D_Address   105
#define L3G4200D_WHO_AM_I  0x0F
#define L3G4200D_ID        0xD3

#define L3G4200D_CTRL_REG1 0x20
#define L3G4200D_CTRL_REG2 0x21
#define L3G4200D_CTRL_REG3 0x22
#define L3G4200D_CTRL_REG4 0x23
#define L3G4200D_CTRL_REG5 0x24

#define L3G4200D_DATA_TEMP 0x26
#define L3G4200D_DATA_XLSB 0x28 // first data register
#define L3G4200D_DATA_XMSB 0x29
#define L3G4200D_DATA_YLSB 0x2A
#define L3G4200D_DATA_YMSB 0x2B
#define L3G4200D_DATA_ZLSB 0x2C
#define L3G4200D_DATA_ZMSB 0x2D


xyzInts_t* readGyroXYZ();
int getGyroXvalue();
int getGyroYvalue();
int getGyroZvalue();
int getGyroTemp();
int checkL3G4200D();
int setupL3G4200D(int scale);

#endif // L3G4200_H
