/***************************************************
  Based on L3G4200D Tripple Axis Gyroscope + Arduino
  Wednesday, June 15 th , 2011 from Adam Meyer
  http://bildr.org/2011/06/l3g4200d-arduino/

  Which in part is based on code by Jim Lindblom
  SparkFun Electronics (https://www.sparkfun.com/products/10612)
  date: 4/18/11
  license: CC-SA 3.0 - Use this code however you'd like, all we ask
  for is attribution. And let us know if you've improved anything! 
 ****************************************************/
 
/**************************************************************************
 Modifications were only made for integration and reducing firmware 
 footprint
 F.J. Kraan, fjkraan@xs4all.nl. 2013-12-28
 **************************************************************************/
 
 #include <Arduino.h>
 
 #include "L3G4200D.h"
 #include "I2C.h"
 
 
xyzInts_t       gm;
xyzInts_t*      gyrometer = &gm;
xyzBytes_xSB_t  gud;
xyzBytes_xSB_t* gUnsortedData = &gud; 

xyzInts_t* readGyroXYZ() {
    read6Register(L3G4200D_Address, L3G4200D_DATA_XLSB, gUnsortedData);
    // L3G4200D registers are big endian oriented
    gyrometer->x = gUnsortedData->x1 << 8 | gUnsortedData->x0;
    gyrometer->y = gUnsortedData->y1 << 8 | gUnsortedData->y0;
    gyrometer->z = gUnsortedData->z1 << 8 | gUnsortedData->z0;
    return gyrometer;
}

int getGyroXvalue() {
//  byte xMSB = readRegister(L3G4200D_Address, L3G4200D_DATA_XMSB);
//  byte xLSB = readRegister(L3G4200D_Address, L3G4200D_DATA_XLSB);
//  return((xMSB << 8) | xLSB);
  return(read2RegisterBE(L3G4200D_Address, L3G4200D_DATA_XLSB));
}

int getGyroYvalue() {
//  byte yMSB = readRegister(L3G4200D_Address, L3G4200D_DATA_YMSB);
//  byte yLSB = readRegister(L3G4200D_Address, L3G4200D_DATA_YLSB);
//  return((yMSB << 8) | yLSB);
  return(read2RegisterBE(L3G4200D_Address, L3G4200D_DATA_YLSB));
} 

int getGyroZvalue() {
//  byte zMSB = readRegister(L3G4200D_Address, L3G4200D_DATA_ZMSB);
//  byte zLSB = readRegister(L3G4200D_Address, L3G4200D_DATA_ZLSB);
//  return ((zMSB << 8) | zLSB);
  return(read2RegisterBE(L3G4200D_Address, L3G4200D_DATA_ZLSB));  
}  

int getGyroTemp() {
   return readRegister(L3G4200D_Address, L3G4200D_DATA_TEMP);  
}

int checkL3G4200D() {
  return readRegister(L3G4200D_Address, L3G4200D_WHO_AM_I);
}

int setupL3G4200D(int scale){
  //From  Jim Lindblom of Sparkfun's code

  // Enable x, y, z and turn off power down:
  writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG1, 0b00001111); // 0x0F

  // If you'd like to adjust/use the HPF, you can edit the line below to configure L3G4200D_CTRL_REG2:
  writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG2, 0b00000000);

  // Configure L3G4200D_CTRL_REG3 to generate data ready interrupt on INT2
  // No interrupts used on INT1, if you'd like to configure INT1
  // or INT2 otherwise, consult the datasheet:
  writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG3, 0b00001000); // 0x08

  // L3G4200D_CTRL_REG4 controls the full-scale range, among other things:

  if(scale == 250){
    writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00000000); // 0x00
  }else if(scale == 500){
    writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00010000); // 0x10
  }else{
    writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00110000); // 0x30
  }

  // L3G4200D_CTRL_REG5 controls high-pass filtering of outputs, use it
  // if you'd like:
  writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG5, 0b00000000);
}
