/*
    HMC5883L.cpp
    Based on I2CBus.cpp by Seb Madgwick
*/

//------------------------------------------------------------------------------
// Includes

#include <Arduino.h>
#include "HMC5883L.h"
#include "I2C.h"
#include "generic.h"

xyzInts_t       mm;
xyzInts_t       *magnetometer = &mm;
xyzBytes_xSB_t  mud;
xyzBytes_xSB_t  *mUnsortedData = &mud;

xyzInts_t* readMagnetoXYZ() {
    read6Register(HMC5883_Addr, HMC5883_X_Addr, mUnsortedData);
    // HMC5883L has little endian register order
    magnetometer->x = mUnsortedData->x0 << 8 | mUnsortedData->x1;
    magnetometer->y = mUnsortedData->y0 << 8 | mUnsortedData->y1;
    magnetometer->z = mUnsortedData->z0 << 8 | mUnsortedData->z1;
    return magnetometer;
}
