/*
Version 4
*/

#include <OscSerial.h>
#include <EthernetUdp.h>
#include <SPI.h>  
#include <Wire.h>

#include "generic.h"
#include "I2C.h"
#include "L3G4200D.h"
#include "BMP085.h"
#include "HMC5883L.h"
#include "Sensor.h"
#include "ADXL345.h"

#define LED 13

OscSerial oscSerial;

long timer;

Adafruit_BMP085 BMP085_bmp;

/* Assign a unique ID to this sensor at the same time */
Adafruit_ADXL345_Unified ADXL345_accel = Adafruit_ADXL345_Unified(12345);  

void oscEvent(OscMessage &m) { // *note the & before msg
    // receive a message 
    m.plug("/led", myFunction); 
}

void myFunction(OscMessage &m) {  // *note the & before msg
  // getting to the message data 
  int value = m.getInt(0); 
  if (value == 0) digitalWrite(13, LOW);
  if (value == 1) digitalWrite(13, HIGH);
}

void setup(){

    Wire.begin();
    Serial.begin(57600);
    oscSerial.begin(Serial);
  delay(1000);  

//------  L3G4200D Gyro  
    while (checkL3G4200D() != L3G4200D_ID) {
        digitalWrite(LED, !digitalRead(LED));
        localOscDebug("L3G4200D not found");
        delay(500);
    }
    setupL3G4200D(2000); // Configure L3G4200  - 250, 500 or 2000 deg/sec
 
//------  ADXL345 Accelerometer  
    /* Initialise the sensor */
    while(!ADXL345_init()) {
        digitalWrite(LED, !digitalRead(LED));
        localOscDebug("ADXL345 not found");
        delay(500);
    }
    /* Set the range to whatever is appropriate for your project */
    ADXL345_setRange(ADXL345_RANGE_16_G);
    // displaySetRange(ADXL345_RANGE_8_G);
    // displaySetRange(ADXL345_RANGE_4_G);
    // displaySetRange(ADXL345_RANGE_2_G);
    
//------  HMC5883 compass
    writeRegister(HMC5883_Addr, byte(0x02), byte(0x00));
  
//------  BMP085 Pressure & Temp

    BMP085_bmp.begin();
  
//------  Startup message  
    delay(1000); //wait for all the sensors to be ready 
    OscMessage msgG("/11AoC/version");
    msgG.add(4);
    oscSerial.send(msgG);
    
//    localOscDebug("starting");
}

void loop(){
  long now = millis();
  if (now-timer > 500) {  
    
//------  L3G4200D Gyro 
    xyzInts_t* gyro = readGyroXYZ();	

    OscMessage msgG("/11AoC/gyro");
    msgG.add(gyro->x);
    msgG.add(gyro->y);
    msgG.add(gyro->z);
    msgG.add(getGyroTemp());
    oscSerial.send(msgG); 

//------  ADXL345 Accelerometer 
  
    /* Get a new sensor event */ 
    sensors_event_t ADXL345_event; 
    ADXL345_accel.getEvent(&ADXL345_event);
 
    /* Display the results (acceleration is measured in m/s^2) */
    OscMessage msgA("/11AoC/accel"); 
    msgA.add(ADXL345_event.acceleration.x); 
    msgA.add(ADXL345_event.acceleration.y); 
    msgA.add(ADXL345_event.acceleration.z); 
    oscSerial.send(msgA); 

//------  HMC5883 compass
    xyzInts_t* magneto = readMagnetoXYZ();
  
    // Print raw values
    OscMessage msgC("/11AoC/compass");
    msgC.add(magneto->x);
    msgC.add(magneto->y);
    msgC.add(magneto->z);
    oscSerial.send(msgC);
  
//------  BMP085 Pressure & Temp 
    float BMP085_temp = BMP085_bmp.readTemperature();
    long  BMP085_pressure = BMP085_bmp.readPressure();
  
    OscMessage msgB("/11AoC/barotemp");
    msgB.add(BMP085_temp);
    msgB.add(BMP085_pressure);
    oscSerial.send(msgB);
    
    timer = now;
  }
    
  oscSerial.listen();
}

void localOscDebug(char *message) {
    OscMessage msgB("/11AoC/debug");
    msgB.add(message);
    oscSerial.send(msgB);   
}


