/*
Version 3
Module: 
http://www.banggood.com/9-Axis-BMP085-Magnetic-Field-Acceleration-Gyro-Atmospheric-Module-p-89600.html

Compass - HMC5883
http://learn.parallax.com/KickStart/29133

Gyro - L3G4200D
http://bildr.org/2011/06/l3g4200d-arduino/

Accelerometer - ADXL345
https://github.com/adafruit/Adafruit_ADXL345 (uncomment line 24: #ifdef USE_I2C)
https://github.com/adafruit/Adafruit_Sensor/blob/master/Adafruit_Sensor.h (add this file to Adafruit_ADXL345 library)

Air pressure - BMP085
https://github.com/adafruit/Adafruit-BMP085-Library

OSC for Arduino
http://www.deadpixel.ca/files/arduino-osc-1.zip
*/

// MESSAGE PROTOCOL OBJECT
#include <OscSerial.h>

// tile support libraries
#include <EthernetUdp.h>
#include <SPI.h>  

OscSerial oscSerial;
long timer;

#include <Wire.h>

#include <Adafruit_Sensor.h>
#include <Adafruit_ADXL345_U.h>

/* Assign a unique ID to this sensor at the same time */
Adafruit_ADXL345_Unified ADXL345_accel = Adafruit_ADXL345_Unified(12345);

#define L3G4200D_CTRL_REG1 0x20
#define L3G4200D_CTRL_REG2 0x21
#define L3G4200D_CTRL_REG3 0x22
#define L3G4200D_CTRL_REG4 0x23
#define L3G4200D_CTRL_REG5 0x24

int L3G4200D_Address = 105; //I2C address of the L3G4200D

int L3G4200D_x;
int L3G4200D_y;
int L3G4200D_z;

#define HMC5883_Addr 0x1E               // 7-bit address of HMC5883 compass

#include <Adafruit_BMP085.h>

Adafruit_BMP085 BMP085_bmp;


void L3G4200D_getGyroValues(){

  byte xMSB = L3G4200D_readRegister(L3G4200D_Address, 0x29);
  byte xLSB = L3G4200D_readRegister(L3G4200D_Address, 0x28);
  L3G4200D_x = ((xMSB << 8) | xLSB);

  byte yMSB = L3G4200D_readRegister(L3G4200D_Address, 0x2B);
  byte yLSB = L3G4200D_readRegister(L3G4200D_Address, 0x2A);
  L3G4200D_y = ((yMSB << 8) | yLSB);

  byte zMSB = L3G4200D_readRegister(L3G4200D_Address, 0x2D);
  byte zLSB = L3G4200D_readRegister(L3G4200D_Address, 0x2C);
  L3G4200D_z = ((zMSB << 8) | zLSB);
}

int setupL3G4200D(int scale){
  //From  Jim Lindblom of Sparkfun's code

  // Enable x, y, z and turn off power down:
  L3G4200D_writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG1, 0b00001111);

  // If you'd like to adjust/use the HPF, you can edit the line below to configure L3G4200D_CTRL_REG2:
  L3G4200D_writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG2, 0b00000000);

  // Configure L3G4200D_CTRL_REG3 to generate data ready interrupt on INT2
  // No interrupts used on INT1, if you'd like to configure INT1
  // or INT2 otherwise, consult the datasheet:
  L3G4200D_writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG3, 0b00001000);

  // L3G4200D_CTRL_REG4 controls the full-scale range, among other things:

  if(scale == 250){
    L3G4200D_writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00000000);
  }else if(scale == 500){
    L3G4200D_writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00010000);
  }else{
    L3G4200D_writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG4, 0b00110000);
  }

  // L3G4200D_CTRL_REG5 controls high-pass filtering of outputs, use it
  // if you'd like:
  L3G4200D_writeRegister(L3G4200D_Address, L3G4200D_CTRL_REG5, 0b00000000);
}

void L3G4200D_writeRegister(int deviceAddress, byte address, byte val) {
    Wire.beginTransmission(deviceAddress); // start transmission to device 
    Wire.write(address);       // send register address
    Wire.write(val);         // send value to write
    Wire.endTransmission();     // end transmission
}

int L3G4200D_readRegister(int deviceAddress, byte address){

    int v;
    Wire.beginTransmission(deviceAddress);
    Wire.write(address); // register to read
    Wire.endTransmission();

    Wire.requestFrom(deviceAddress, 1); // read a byte

    while(!Wire.available()) {
        // waiting
    }

    v = Wire.read();
    return v;
}

void oscEvent(OscMessage &m) { // *note the & before msg
  // receive a message 
  m.plug("/led", myFunction); 
}

void myFunction(OscMessage &m) {  // *note the & before msg
  // getting to the message data 
  int value = m.getInt(0); 
  if (value == 0) digitalWrite(13, LOW);
  if (value == 1) digitalWrite(13, HIGH);
}

void setup(){

  Wire.begin();
  Serial.begin(9600);
  oscSerial.begin(Serial);  

//------  L3G4200D Gyro  
//  Serial.println("starting up L3G4200D");
  setupL3G4200D(2000); // Configure L3G4200  - 250, 500 or 2000 deg/sec
 
//------  ADXL345 Accelerometer  
//  Serial.println("ADXL345 Accelerometer Test"); Serial.println("");
  
  /* Initialise the sensor */
  while(!ADXL345_accel.begin()) {
    Serial.println("#ERROR: initialising ADXL345"); 
    delay(500);
  }
  
  /* Set the range to whatever is appropriate for your project */
  ADXL345_accel.setRange(ADXL345_RANGE_16_G);
  // displaySetRange(ADXL345_RANGE_8_G);
  // displaySetRange(ADXL345_RANGE_4_G);
  // displaySetRange(ADXL345_RANGE_2_G);
    
//------  HMC5883 compass
  // Set operating mode to continuous 
  Wire.beginTransmission(HMC5883_Addr); 
  Wire.write(byte(0x02));
  Wire.write(byte(0x00));
  Wire.endTransmission(); 
  
//------  BMP085 Pressure & Temp
  BMP085_bmp.begin();
  delay(1500); //wait for all the sensors to be ready 
}

void loop(){
  long now = millis();
  if (now-timer > 500) {  
    
//------  L3G4200D Gyro 	
    L3G4200D_getGyroValues();  // This will update x, y, and z with new values

    OscMessage msgG("/11AoC/gyro");
    msgG.add(L3G4200D_x);
    msgG.add(L3G4200D_y);
    msgG.add(L3G4200D_z);
    oscSerial.send(msgG);

//------  ADXL345 Accelerometer 
  
    /* Get a new sensor event */ 
    sensors_event_t ADXL345_event; 
    ADXL345_accel.getEvent(&ADXL345_event);
 
    /* Display the results (acceleration is measured in m/s^2) */
    OscMessage msgA("/11AoC/accel"); 
    msgA.add(ADXL345_event.acceleration.x); 
    msgA.add(ADXL345_event.acceleration.y); 
    msgA.add(ADXL345_event.acceleration.z); 
    oscSerial.send(msgA);

//------  HMC5883 compass
    int HMC5883_x, HMC5883_y, HMC5883_z;

    // Initiate communications with compass
    Wire.beginTransmission(HMC5883_Addr);
    Wire.write(byte(0x03));       // Send request to X MSB register
    Wire.endTransmission();

    Wire.requestFrom(HMC5883_Addr, 6);    // Request 6 bytes; 2 bytes per axis
    if(Wire.available() <=6) {    // If 6 bytes available
      HMC5883_x = Wire.read() << 8 | Wire.read();
      HMC5883_z = Wire.read() << 8 | Wire.read();
      HMC5883_y = Wire.read() << 8 | Wire.read();
    }
  
    // Print raw values
    OscMessage msgC("/11AoC/compass");
    msgC.add(HMC5883_x);
    msgC.add(HMC5883_y);
    msgC.add(HMC5883_z); 
    oscSerial.send(msgC);
  
//------  BMP085 Pressure & Temp 
    float BMP085_temp = BMP085_bmp.readTemperature();
    long  BMP085_pressure = BMP085_bmp.readPressure();
  
    OscMessage msgB("/11AoC/barotemp");
    msgB.add(BMP085_temp);
    msgB.add(BMP085_pressure);
    oscSerial.send(msgB);
    
    timer = now;
  }
    
  oscSerial.listen();   
  
}

