/***************************************************
  Based on L3G4200D Tripple Axis Gyroscope + Arduino
  Wednesday, June 15 th , 2011 from Adam Meyer
  http://bildr.org/2011/06/l3g4200d-arduino/

  Which in part is based on code by Jim Lindblom
  SparkFun Electronics (https://www.sparkfun.com/products/10612)
  date: 4/18/11
  license: CC-SA 3.0 - Use this code however you'd like, all we ask
  for is attribution. And let us know if you've improved anything! 
 ****************************************************/
 
/**************************************************************************
 Modifications were only made for integration and reducing firmware 
 footprint
 F.J. Kraan, fjkraan@xs4all.nl. 2013-12-28
 
 Datasheet:
 http://dlnmh9ip6v2uc.cloudfront.net/datasheets/Sensors/Gyros/3-Axis/CD00265057.pdf
***************************************************************************/

#ifndef L3G4200D_h
#define L3G4200D_h

#include "generic.h"

//I2C address of the L3G4200D
#define L3G4200D_Address   105

//Registers
#define L3G4200D_WHO_AM_I      0x0F
#define L3G4200D_CTRL_REG1     0x20
#define L3G4200D_CTRL_REG2     0x21
#define L3G4200D_CTRL_REG3     0x22
#define L3G4200D_CTRL_REG4     0x23
#define L3G4200D_CTRL_REG5     0x24
#define L3G4200D_REFERENCE     0x25
#define L3G4200D_OUT_TEMP      0x26
#define L3G4200D_STATUS_REG    0x27
#define L3G4200D_DATA_XLSB     0x28 // first data register
#define L3G4200D_DATA_XMSB     0x29
#define L3G4200D_DATA_YLSB     0x2A
#define L3G4200D_DATA_YMSB     0x2B
#define L3G4200D_DATA_ZLSB     0x2C
#define L3G4200D_DATA_ZMSB     0x2D
#define L3G4200D_FIFO_CTRL_REG 0x2E
#define L3G4200D_FIFO_SRC_REG  0x2F
#define L3G4200D_INT1_CFG      0x30
#define L3G4200D_INT1_SRC      0x31
#define L3G4200D_TSH_XH        0x32
#define L3G4200D_TSH_XL        0x33
#define L3G4200D_TSH_YH        0x34
#define L3G4200D_TSH_YL        0x35
#define L3G4200D_TSH_ZH        0x36
#define L3G4200D_TSH_ZL        0x37
#define L3G4200D_INT1_DURATION 0x38

// Constants
#define L3G4200D_ID            0xD3
#define L3G4200D_SCALE_250     0b00000000
#define L3G4200D_SCALE_500     0b00010000
#define L3G4200D_SCALE_2K      0b00110000

#define L3G4200D_LSB2DPS       0.00875f

bool L3G4200D_init(int scale);
byte L3G4200D_getDeviceID(void);
xyzInts_t* readGyroXYZ();
int getGyroXvalue();
int getGyroYvalue();
int getGyroZvalue();
int getGyroTemp();
int checkL3G4200D();
int setupL3G4200D(int scale);

#endif // L3G4200_H
