/*
    HMC5883L.cpp
    Based on I2CBus.cpp by Seb Madgwick
*/

//------------------------------------------------------------------------------
// Includes

#include <Arduino.h>
#include "HMC5883L.h"
#include "I2C.h"
#include "generic.h"

xyzInts_t       mm;
xyzInts_t       *magnetometer = &mm;
xyzBytes_xSB_t  mud;
xyzBytes_xSB_t  *mUnsortedData = &mud;

byte gain = HMC5883L_GAIN_1P3G;


long HMC5883L_getDeviceID(void) {
    // Check device ID register
    byte idA = readRegister(HMC5883L_ADDRESS, HMC5883L_ID_REG_A);
    byte idB = readRegister(HMC5883L_ADDRESS, HMC5883L_ID_REG_B);
    byte idC = readRegister(HMC5883L_ADDRESS, HMC5883L_ID_REG_C);
  
    return (idA << 16 | idB << 8 | idC);
}

bool HMC5883L_init(byte gain) {
    /* Check connection */
    long deviceid = HMC5883L_getDeviceID();
    if (deviceid != (HMC5883L_ID_A << 16 | HMC5883L_ID_B << 8 | HMC5883L_ID_C)) {
      /* No HMC5883L detected ... return false */
      return false;
    }
    // Set operating mode
    writeRegister(HMC5883L_ADDRESS, HMC5883L_MODE_REG, HMC5883L_I2C_STANDARD | HMC5883L_MODE_CONT);
    // Set output data rate
    writeRegister(HMC5883L_ADDRESS, HMC5883L_CONFIG_REG_A, HMC5883L_MEAS_NORM | HMC5883L_RATE_15HZ | HMC5883L_AVG_1);
    // Set device gain
    writeRegister(HMC5883L_ADDRESS, HMC5883L_CONFIG_REG_B, gain);
    return true;
}

xyzInts_t* readMagnetoXYZ() {
    read6Register(HMC5883L_ADDRESS, HMC5883L_DOUT_X_MSB, mUnsortedData);
    // HMC5883L has little endian register order
    magnetometer->x = mUnsortedData->x0 << 8 | mUnsortedData->x1;
    magnetometer->y = mUnsortedData->y0 << 8 | mUnsortedData->y1;
    magnetometer->z = mUnsortedData->z0 << 8 | mUnsortedData->z1;
    return magnetometer;
}

bool HMC5883L_ready() {
    return (readRegister(HMC5883L_ADDRESS, HMC5883L_STAT_REG) & 0x01);
}

byte HMC5883L_setGain(byte gain) {
    writeRegister(HMC5883L_ADDRESS, HMC5883L_CONFIG_REG_B, gain);
}
