#include "m_pd.h"

static t_class *pan2_tilde_class;

typedef struct _pan2_tilde {
  t_object  x_obj;
  t_sample  f_pan2;
  t_sample  f;
} t_pan2_tilde;

/* The actual work is done here */
static t_int *pan2_tilde_perform(t_int *w)
{
  t_pan2_tilde   *x = (t_pan2_tilde *)(w[1]); /* pointer to instance struct */
  t_sample     *in1 =     (t_sample *)(w[2]); /* input vector/array */
  t_sample    *out1 =     (t_sample *)(w[3]); /* first output vector/array */
  t_sample    *out2 =     (t_sample *)(w[4]); /* second output vector/array */
  int             n =            (int)(w[5]); /* vector/array size */
  t_sample f_pan2 = 
	(x->f_pan2 < 0) ? 0.0 : (x->f_pan2 > 1) ? 1.0 : x->f_pan2;

  while (n--) {
    *out1++ = (*in1) * (1 - f_pan2);
    *out2++ = (*in1++) * f_pan2;
  }
  return (w+6);
}

/* register the method to exectue for dsp processing. Note the inlets and 
   outlets are used implicitily here, via the sp array. Compare this to the 
   explicit way used in counter2, where they are of the object struct */
static void pan2_tilde_dsp(t_pan2_tilde *x, t_signal **sp)
{
  /* note the similarity between the arguments and the structure of the
     argument of the '*pan_tilde_perform' method */
  dsp_add(pan2_tilde_perform, 	/* register the perform method */
          5, 			/* number of following parameters */
          x,			/* pointer to the object struct */
          sp[0]->s_vec, 	/* first inlet signal */
          sp[1]->s_vec, 	/* first outlet signal */
          sp[2]->s_vec, 	/* second outlet signal */
          sp[0]->s_n);		/* the size of the vectors/arrays */
}

/* The *_new method is called for each instantiation of the class */
static void *pan2_tilde_new(t_floatarg f)
{
  t_pan2_tilde *x = (t_pan2_tilde *)pd_new(pan2_tilde_class);

  x->f_pan2 = f;
  
  /* create a message inlet for floats */
  floatinlet_new (&x->x_obj, &x->f_pan2);

  /* create a signal outlet */
  outlet_new(&x->x_obj, &s_signal);

  /* create another signal outlet */
  outlet_new(&x->x_obj, &s_signal);

  return (void *)x;
}

/* The *_setup method contains the class definition and is called at the 
   startup of the dsp engine */
void pan2_tilde_setup(void) {
  pan2_tilde_class = 
	class_new(gensym("pan2~"),	/* register the 'pan2~' symbol */
					/* declare initialization method */
        	  (t_newmethod)pan2_tilde_new, /* method to initialize objects */	
        	  0, 			/* method to cleanup or 0 */	
		  sizeof(t_pan2_tilde),	/* size of the object struct */
       	 	  CLASS_DEFAULT, 	/* make it type CLASS_PATCHABLE */
        	  A_DEFFLOAT, 		/*  */
		  0);			/*  */

 class_addmethod(pan2_tilde_class,	/*  */
        	  (t_method)pan2_tilde_dsp, /*  */
		  gensym("dsp"),	/* declare this is a signal class */
		  0);			/*  */

 CLASS_MAINSIGNALIN(pan2_tilde_class, /* pointer to the class struct */
		     t_pan2_tilde,    /* pointer to the object struct */
		     f);	      /* dummy variable */
}

