#include "m_pd.h"

/* declare helloworldSym_class as a t_class type */
static t_class *helloworldSym_class;

/* this struct is the 'handle' the Pd core will have to the instance. The
   helloworldSym_new method initializes it with a pointer to this instance */
typedef struct _helloworldSym {
  t_object  x_obj;
  t_outlet  *x_data_outlet;
} t_helloworldSym;

/* the 'payload' or behaviour of this object */
static void helloworldSym_bang(t_helloworldSym *x)
{
  post("Hello world !!");

  outlet_symbol( x->x_data_outlet, gensym("HelloWorld"));

}

/* the 'constructor' method which defines the t_helloworldSym struct for this 
   instance and returns it to the caller which is the Pd core */
static void *helloworldSym_new(void)
{
  t_helloworldSym *x = (t_helloworldSym *)pd_new(helloworldSym_class);

  x->x_data_outlet = outlet_new(&x->x_obj, &s_symbol);

  return (void *)x;
}

/* This method is the only one the Pd core expects to be present */
void helloworldSym_setup(void) {
  /* this registers the 'helloworldSym' class. The 'helloworldSym_new' method will 
     be executed at each instantiation. */
  helloworldSym_class = class_new(gensym("helloworldSym"),
        		       (t_newmethod)helloworldSym_new,
        			0, 
				sizeof(t_helloworldSym),
        			CLASS_DEFAULT, 
				0);

  /* this registers the helloworldSym_bang method as action when a bang is received */
  class_addbang(helloworldSym_class, helloworldSym_bang);
}

