#include "m_pd.h"

static t_class *counter2_class;

typedef struct _counter2 {
  t_object  x_obj;
  t_int     i_count;		/* current count value */
  t_float   step;		/* count increment. As the couter is an int, the fractional 
				   part of the step is ignored */
  t_int     i_down,  i_up;	/* count boundaries */
  t_outlet  *f_out,  *b_out;    /* here the outlets are also declared so they can be
                                   addressed explicitly */
} t_counter2;

static void counter2_bang(t_counter2 *x) { /* bang handler */
  t_float f   = x->i_count;
  t_int step  = x->step;
  x->i_count += step;

  if (x->i_down - x->i_up) { 			/*  x->i_down != x->i_up  */
    if ((step > 0) && (x->i_count > x->i_up)) { /* count up and counter too large */ 
      x->i_count = x->i_down;				/* reset counter */
      outlet_bang(x->b_out);				/* bang to the bang outlet */
    } else if (x->i_count < x->i_down) {	/* count down and counter too small */	
      x->i_count = x->i_up;				/* reset counter */
      outlet_bang(x->b_out);				/* bang to the bang outlet */
    }
  }

  outlet_float(x->f_out, f);			/* new count value to float outlet */
}

static void counter2_reset(t_counter2 *x) {
  x->i_count = x->i_down;
  post("reset counter to x->i_down value: %d",x->i_down);
}

static void counter2_set(t_counter2 *x, t_floatarg f) {
  x->i_count = f;
  post("set counter to: %f", f);
}

static void counter2_bound(t_counter2 *x, t_floatarg f1, t_floatarg f2) {
  x->i_down = (f1<f2)?f1:f2;	/* lower boundary */
  x->i_up   = (f1>f2)?f1:f2;	/* upper boundary */
  post("set bounds to %d (x->i_down) and %d (x->i_up)", x->i_down, x->i_up);
}

static void *counter2_new(t_symbol *s, int argc, t_atom *argv) {
  t_counter2 *x = (t_counter2 *)pd_new(counter2_class);
  t_float f1=0, f2=0;

  x->step = 1;
  switch(argc) {	/* smart way to process only the actual arguments */
  default:
  case 3:
    x->step = atom_getfloat(argv+2);
  case 2:
    f2 = atom_getfloat(argv+1);
  case 1:
    f1 = atom_getfloat(argv);
    break;
/*  case 0: */
  }
  if (argc<2) f2 = f1;

  x->i_down = (f1 < f2) ? f1 : f2;	/* lower boundary */
  x->i_up   = (f1 > f2) ? f1 : f2;	/* upper boundary */

  x->i_count = x->i_down;		/* initialize counter */

  /* create second inlet for the count boundaries */
  inlet_new(&x->x_obj, &x->x_obj.ob_pd, gensym("list"), gensym("bound"));

  /* create third inlet and put the received value in x->step */
  floatinlet_new(&x->x_obj, &x->step);

  /* create the first (left) outlet for s_float (=t_symbol). Note the outlet 
     is explicitly part of the object struct. Compare this with the implicit
     method in counter2. */
  x->f_out = outlet_new(&x->x_obj, &s_float);

  /* create the second (right) outlet for s_bang (=t_symbol) */
  x->b_out = outlet_new(&x->x_obj, &s_bang);

  return (void *)x;
}

void counter2_setup(void) {
  counter2_class = class_new(gensym("counter2"),
        (t_newmethod)counter2_new,
        0, sizeof(t_counter2),
        CLASS_DEFAULT, 
        A_GIMME, 0);

  /* add a bang method */
  class_addbang  (counter2_class, counter2_bang);

  /* add a method for the 'reset' message */
  class_addmethod(counter2_class,	/* the class to add the method to */
        (t_method)counter2_reset, 	/* the method name */
        gensym("reset"), 		/* the message that triggers the method call */
	0);				/* method argument terminator, so none here */

  /* add a method for the 'set f' message. One float argument for counter2_set() */
  class_addmethod(counter2_class, 
        (t_method)counter2_set, gensym("set"),
        A_DEFFLOAT, 0);

  /* add a method for the 'bound f1 f2' message. Two float arguments for counter2_bound() */
  class_addmethod(counter2_class,
        (t_method)counter2_bound, gensym("bound"),
        A_DEFFLOAT, A_DEFFLOAT, 0);

  /* overrule the default name of the help patch */
  class_sethelpsymbol(counter2_class, gensym("help-counter2"));
}

