//sensorHouder4

include <../../libraries/prism.scad>

$fn = 64;

lagerDiam = 16.1;
lagerDiepte = 5.0;

wandDikte = 2.0;

asDiam = 5.1;
montageOffset = 5.0;
montagePlaatDikte = 4.0;
montageBreedte = 35;
montageAfloopBreedte = 20;

houderBreedte = 18.0;
houderDiepte = wandDikte;
houderHoogte = 27.5;
houderOffset = 5.0;

sensorHoleOffset = 5.0;
sensorHoogte = 25.0;
sensorXoffset = 2.0;

solderHoleB = 10.0;
solderHoleH = 13.5;
solderHoleD = 1.6;

// houder
difference() {
    union() {
        translate([0-montageBreedte / 2, 0, 0]) cube([montageBreedte, montagePlaatDikte, houderDiepte]);
        translate([houderOffset, 0, 0]) cube([houderBreedte, houderHoogte+5, houderDiepte]);
    }
    translate([houderOffset + sensorXoffset, sensorHoogte, -0.01]) {
        translate([0,  sensorHoleOffset, 0]) cylinder(d = 2.0, h = houderDiepte + 0.02);
        translate([0, -sensorHoleOffset, 0]) cylinder(d = 2.0, h = houderDiepte + 0.02);
        translate([9, 0, 1.4]) cube([solderHoleH, solderHoleB, solderHoleD +0.01], true);
    }
}

// montage
difference() {
    translate([-montageBreedte+10, 0, 0]) 
        cube([montageBreedte, montagePlaatDikte, houderBreedte / 2 + 2.5]);
    hull() {
    translate([ montageOffset, montagePlaatDikte + 0.01, houderDiepte + 5]) rotate([90, 0, 0]) 
        cylinder(d = asDiam, h = montagePlaatDikte + 0.02);
    translate([-montageOffset * 4, montagePlaatDikte + 0.01, houderDiepte + 5]) rotate([90, 0, 0]) 
        cylinder(d = asDiam, h = montagePlaatDikte + 0.02);
    }
}

translate([montageBreedte / 4+1.1, montagePlaatDikte, houderBreedte / 2 + 2]) 
    prism(montagePlaatDikte, houderBreedte / 2, montageAfloopBreedte - 7);