//motorHouder3

$fn = 32;

motorDiam = 28.0;
motorSchroefDiam = 3.0;
motorSchroefAfstand = 16.0;
motorCenterDiam = 10.5;
wandDikte = 4.0;
houderBreedte = 28.0;
houderDiepte = 4.0;
asHoogte = 25.0;
asDiam = 5.0;
montageOffset = 10.0;
prismW = 2.5;

include<../../libraries/screwShapes1.scad>
include<../../libraries/prism.scad>

translate([houderBreedte/2, asHoogte-houderDiepte, wandDikte+2]) rotate([0, 0, -90]) prism(houderBreedte, prismW, prismW);

difference() {
    union() {
        cylinder(d = motorDiam, h = wandDikte);
        translate([-motorDiam/2, 0, 0]) cube([motorDiam, asHoogte, wandDikte]);
    }
    translate([0, 0, -0.01]) {
        cylinder(d = motorCenterDiam, h = wandDikte + 0.02);
        translate([-motorSchroefAfstand / 2, 0, 0]) 
            rotate([0, 180, 0]) translate([0, 0, -wandDikte - 0.02]) flatheadM25(wandDikte + 0.02);
        translate([ motorSchroefAfstand / 2, 0, 0]) 
            rotate([0, 180, 0]) translate([0, 0, -wandDikte - 0.02]) flatheadM25(wandDikte + 0.02);
    }
}

translate([-houderBreedte / 2 - 2.5, asHoogte - wandDikte, 0]) cube([houderBreedte + 5, houderDiepte, wandDikte]);
translate([0, 0, wandDikte]) {
    difference() {
        translate([-houderBreedte / 2 - 2.5, asHoogte - wandDikte, 0]) 
            cube([houderBreedte + 5, houderDiepte, houderBreedte / 2]);
        translate([ montageOffset, asHoogte + 0.01, houderBreedte/4]) rotate([90, 0, 0]) 
            cylinder(d = asDiam, h = houderDiepte + 0.02);
        translate([-montageOffset, asHoogte + 0.01, houderBreedte/4]) rotate([90, 0, 0]) 
            cylinder(d = asDiam, h = houderDiepte + 0.02);
    }
}