// axisCoupler3

$fn = 32;

motorAxisDiam = 2.4;
couplerDiam = 20.0;
mainAxisDiam = 5.0;
couplerLength = 20.0;
m3ThreadHoleDiam = 4.1;
m3HeadHeight = 3.0;
m3HeadDiam = 5.5;
m5nutDiam = 9.2;
m5nutHeight = 4.0;
m5ThreadDiam = 5.3;

coupleGap = 0.5;

module motorPart() {
  difference() {
    cylinder(d = couplerDiam, h = couplerLength * 0.75);
    // axis hole
    translate([0, 0, -0.01]) cylinder(d = motorAxisDiam, h = couplerLength * 0.8 + 0.02);
    // center hole
    translate([0, 0, couplerLength * 0.5]) {
        cylinder(d = couplerDiam * 0.5, h = couplerLength * 0.25 + 0.02);
 //       cylinder(d = couplerDiam * 0.5, h = couplerLength * 0.33 + 0.02);
        // segment
        cylinderSegment();
    }
    // side holes
    translate([0, 0, couplerLength * 0.3]) rotate([0, 0, 45]) translate([couplerDiam/2, 0, 0]) rotate([0, -90, 0]) {
        cylinder(d = m3ThreadHoleDiam, h = couplerDiam + 0.02);
        cylinder(d = m3HeadDiam, h = m3HeadHeight + 0.02);
        translate([0, 0, couplerDiam - m3HeadHeight]) cylinder(d = m3HeadDiam, h = m3HeadHeight + 0.02);
    }
  }
}

//translate([15, 0, 0]) motorPart();

module cylinderSegment() {
    difference() {
        cylinder(d = couplerDiam + 0.01, h = couplerLength * 0.25 + 0.02);
        translate([coupleGap, coupleGap, -0.01]) 
            cube([couplerDiam, couplerDiam, couplerLength * 0.25 + 0.02]);
        translate([-coupleGap, -coupleGap, -0.01]) rotate([0, 0, 180]) cube([couplerDiam, couplerDiam, couplerLength * 0.25 + 0.02]);
    }
}

translate([-15, 0, 0]) axisPart();

module axisPart() {
  difference() {
    cylinder(d = couplerDiam, h = couplerLength * 0.5);
    translate([0, 0, -0.01]) cylinder(d = m5ThreadDiam, h = couplerLength * 0.66 + 0.02);
    translate([0, 0,  couplerLength * .25]) cylinder(d = m5nutDiam, h = couplerLength * 0.25 + 0.02);
      // nut hole
    translate([0, 0, couplerLength * 0.25-m5nutHeight]) cylinder(d = m5nutDiam, h = m5nutHeight + 0.02, $fn = 6);
      // segment part
    translate([0, 0, couplerLength * 0.25]) {
        cylinder(d = couplerDiam * 0.33, h = couplerLength * 0.33 + 0.02);
 //       cylinder(d = couplerDiam * 0.5, h = couplerLength * 0.33 + 0.02);
        cylinderSegment();
    }
  }    
}

//cylinderSegment();