//asHouder3

include<../../libraries/prism.scad>

prismW = 2.5;
translate([houderBreedte/2, asHoogte - prismW-1, houderDiepte+prismW]) rotate([0, 0, -90]) 
    prism(houderBreedte, prismW, prismW);

$fn = 64;

lagerDiam = 16.1;
lagerDiepte = 5.0;

wandDikte = 2.0;

asDiam = 5.1;
asHoogte = 25.0;

houderBreedte = lagerDiam + 4 * wandDikte;
houderDiepte = lagerDiepte + wandDikte / 2;

montageOffset = 10.0;
montagePlaatBreedte = 33.0;
montagePlaatDikte = 4.0;

// lagerhouder
difference() {
    union() {
        cylinder(d = houderBreedte, h = houderDiepte);
        translate([-houderBreedte / 2, 0, 0]) cube([houderBreedte, asHoogte, houderDiepte]);
    }
    translate([0, 0, -0.01]) cylinder(d = asDiam, h = houderDiepte + 0.02);
    translate([0, 0, wandDikte / 2]) cylinder(d = lagerDiam, h = houderDiepte);
}

// montage
translate([-montagePlaatBreedte / 2, asHoogte - montagePlaatDikte, 0]) 
    cube([montagePlaatBreedte, montagePlaatDikte, houderDiepte]);
difference() {
    translate([-montagePlaatBreedte / 2, asHoogte - montagePlaatDikte, houderDiepte]) 
        cube([montagePlaatBreedte, montagePlaatDikte, houderBreedte / 2]);
    translate([ montageOffset, asHoogte + 0.01, houderDiepte + 6]) rotate([90, 0, 0]) 
        cylinder(d = asDiam, h = montagePlaatDikte + 0.02);
    translate([-montageOffset, asHoogte + 0.01, houderDiepte + 6]) rotate([90, 0, 0]) 
        cylinder(d = asDiam, h = montagePlaatDikte + 0.02);
}