
#define MAYORVER 1
#define MINORVER 1
#define PATCHVER 0

#include "ptpi.h"
#include <AltSoftSerial.h>

AltSoftSerial mySerial(RXD, TXD); // RX, TX

void setup() {
  initPins();

  // RS232c on breakout board
  mySerial.begin(BAUD);

  delay(100L);
//  mySerial.println("mySerial start");
  // USB console
  Serial.begin(DEBUGBAUD);
  delay(100L);
  Serial.print(F("Version "));
  Serial.print(MAYORVER);
  Serial.print(".");
  Serial.print(MINORVER);
  Serial.print(".");
  Serial.print(PATCHVER);
  Serial.println();
  Serial.println(F("Serial start"));
}

void loop() {
  uint8_t value;

  if (mySerial.available()) {
    value = mySerial.read();
    writeChar(value);
    Serial.print(value);
    blinkPin();
  }
  commandCollector();
}

void writeChar(uint8_t value) {
    outputValue(value);
    digitalWrite(PI_, LOW);
    piDelay();
    digitalWrite(PI_, HIGH);
}

void outputValue(uint8_t chr) {
  #define BYTESIZE 8
  for (uint8_t b = 0; b < BYTESIZE; b++) {
    bool bit  = (chr & (1 << b)) ? 0 : 1 ;   // mask one bit and invert it
    digitalWrite(channels[b], bit);
  }
}

// Outputs are inverted by driver (ULN2003A)
void initPins() {
  #define BYTESIZE 8
  for (uint8_t b = 0; b < BYTESIZE; b++) {
    uint8_t pin = channels[b];
    pinMode(pin, OUTPUT);
    digitalWrite(pin, HIGH);  // pin_ high = pin low, no hole
  }
  pinMode(SPROCKET_, OUTPUT);
  digitalWrite(SPROCKET_, LOW); // SPROCKET_ low = SPROCKET HIGH, punch a sprocket hole

  pinMode(SD_, OUTPUT);
  digitalWrite(SD_, HIGH);  // SD_ high = SD low, forward tape feed
  pinMode(PI_, OUTPUT);
  digitalWrite(PI_, HIGH); 

  pinMode(PR, INPUT);
  pinMode(TL, INPUT);
  pinMode(ERR1, INPUT);
  pinMode(EXT, INPUT);
}

void piDelay() {
  delayMicroseconds(PIPULSE);
}

void commandCollector() {
  if (Serial.available() > 0) {
    int inByte = Serial.read();
    switch(inByte) {
    case '.':
//    case '\r':
    case '\n':
      commandInterpreter();
      clearSerialBuffer();
      setBufPointer = 0;
      break;
    case '\r':
      break;  // ignore carriage return
    default:
      serialBuffer[setBufPointer] = inByte;
      setBufPointer++;
      if (setBufPointer >= SERIALBUFSIZE) {
        Serial.println("Serial buffer overflow. Cleanup.");
        clearSerialBuffer();
        setBufPointer = 0;
      }
    }
  }
}

void commandInterpreter() {
  byte bufByte = serialBuffer[0];
  
  switch(bufByte) {
    case 'B':
    case 'b':
      debugBlinkPin();
      break;
    case 'C':
    case 'c':
      blinkChannel();
      break;
    case 'H':
    case 'h':
    case '?':
      Serial.print(F("Paper Tape Punch v"));
      Serial.print(MAYORVER);
      Serial.print(".");
      Serial.print(MINORVER);
      Serial.print(".");
      Serial.print(PATCHVER);
      Serial.print(" ");
      Serial.println(F("Usage:"));
      Serial.println(F(" B  -    Toggle LED"));
      Serial.println(F(" Cc -    Blink channel (0-8,A,B)"));
      Serial.println(F("         (8 = SPROCKET, A = SD, B = PI"));
      Serial.println(F(" H  -    This help text"));
      Serial.println(F(" Pc -    Punch character"));
      Serial.println(F(" Scccc - Send string"));
      break;
    case 'P':
    case 'p':
      punchChar();
      break;
    case 'S':
    case 's':
      sendString();
      break;
    default:
      Serial.print(bufByte);
      Serial.print(" ");
      Serial.println(F("unsupported"));
      return;
  }
}

void debugBlinkPin() {
  Serial.print("blink");
  digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN));
}

void blinkPin() {
  digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN));
}

void punchChar() {
  Serial.println(serialBuffer[1]);
}

void sendChar(byte chr) {
    mySerial.write(chr);
}

void blinkChannel() {
    if (setBufPointer < 2) {
        Serial.println(F("no channel"));
        return;
    }
    byte channel = serialBuffer[1] - '0';
    if (channel <= '8' || channel == 'A' || channel =='B') {
        Serial.print("Blinking channel ");
        Serial.println(channel);
    } else {
        Serial.println(F("illegal channel"));
        return;
    }
    while(!Serial.available()) {
      if (channel < 8) {  // normal channels
          digitalWrite(channels[channel], !digitalRead(channels[channel]));
      }
      if (channel == 8) {          // sprocket channel
          digitalWrite(SPROCKET_, !digitalRead(SPROCKET_));
      }
      if (channel == 17) {          // 'A' - '0'
          digitalWrite(SD_, !digitalRead(SD_));
      }
      if (channel == 18) {          // 'B' - '0'
          digitalWrite(PI_, !digitalRead(PI_));
      }

      delay(BLINKRATE);
    }
}

void sendString() {
  byte printPointer = 1;
  if (setBufPointer > 1) {
    while (printPointer < setBufPointer) {
      sendChar(serialBuffer[printPointer]);
      printPointer++;
      delay(ALTSERDELAY);
    }
  }
}

void clearSerialBuffer() {
  byte i;
  for (i = 0; i < SERIALBUFSIZE; i++) {
    serialBuffer[i] = 0;
  }
}