/*  IC-test 2 client(Arduino)-server(Python script)
 *   
 *   
 *   Assuming 74LS00 quad NAND
 *   Config command:
 *   C:1,2,Q,4,5,Q,G,Q,9,10,Q,12,13,V
 *   Query command:
 *   Q:0,0,-,0,0,-,G,-,0,0,-,0,0,V
 *   Response:
 *   R:0,0,1,0,0,1,G,1,0,0,1,0.0,V
 *   Q:0,0,-,0,0,-,G,-,0,0,-,0,1,V
 *   R:0,0,1,0,0,1,G,1,0,0,0,1,1,V
 *   ....
 *   Q:1,1,-,1,1,-,G,-,1,1,-,1,1,V
 *   R:1,1,0,1,1,0,G,0,1,1,0,1,1,V
 *  
 */

#include "pinMap.h"

#define VERSION 1.4

#define DEFAULT_DEBUG 0
#define BAUDRATE 9600

#define SERIALBUFSIZE         65
char serialBuffer[SERIALBUFSIZE];
byte setBufPointer = 0;

#define RECORDSIZE 8
#define DATARECORDTYPE 0

#define CLOCK_PULSE     1L
#define EXERCISE_PIN_DELAY 250
#define INPUT_CHANGE_DELAY 1L

byte pinType[MAX_PINCOUNT];
byte pinCount = 0;
byte debug = DEFAULT_DEBUG;
byte powerAPin = 0;

void setup() {
  Serial.begin(BAUDRATE);
  clearPins();
  delay(10);
  Serial.print("Arduino Mega PROM reader ");
  Serial.println(VERSION,1);
}

void loop() {
    commandCollector();

}

void commandCollector() {
  if (Serial.available() > 0) {
    int inByte = Serial.read();
    switch(inByte) {
    case '.':
//    case '\r':
    case '\n':
      commandInterpreter();
      clearSerialBuffer();
      setBufPointer = 0;
      break;
    case '\r':
      break;  // ignore carriage return
    default:
      serialBuffer[setBufPointer] = inByte;
      setBufPointer++;
      if (setBufPointer >= SERIALBUFSIZE) {
        Serial.println("ERROR: Serial buffer overflow. Cleanup.");
        clearSerialBuffer();
        setBufPointer = 0;
      }
    }
  }
}

void commandInterpreter() {
  byte bufByte = serialBuffer[0];
  
  switch(bufByte) {
    case 'F':
    case 'f':
      errorLed();
      break;
    case 'H':
    case 'h':
    case '?':
      usage();
      break;
    case 'I':
    case 'i':
      enableVcc();
      generateDataRecords();
      generateEndRecord();
      disableVcc();
      break;
    default:
      Serial.print((char)bufByte);
      Serial.print(" ");
      Serial.println("unsupported");
      return;
  }
}

void usage() {
  Serial.print("PROMReader2 ");
  Serial.println(VERSION,1);

  Serial.println("Fn - control error LED (n=0,1)");
  Serial.println("H  - this text");
  Serial.println("I  - Generate hex intel data (8x8)");
}

void generateDataRecords() {
  unsigned int startAddress;
  unsigned int endAddress;
  startAddress = 0x000;
  endAddress   = 0x100;
//  printWord(startAddress);
  Serial.print("# 8x8 ROM");
//  printWord(endAddress);
  Serial.println();

  unsigned int i, j;
  unsigned char addressMSB, addressLSB, data;
  unsigned char sumCheckCount = 0;

  setAddrBusOutput();
  chipSelect();

  for (i = startAddress; i < endAddress; i += RECORDSIZE) {
    sumCheckCount = 0;
    Serial.print(":");
    printByte(RECORDSIZE);  
    sumCheckCount -= RECORDSIZE;
    addressMSB = i >> 8;
    addressLSB = i & 0xFF;
    printByte(addressMSB);
    printByte(addressLSB);
    sumCheckCount -= addressMSB;
    sumCheckCount -= addressLSB;
    printByte(DATARECORDTYPE);
    sumCheckCount -= DATARECORDTYPE;
    for (j = 0; j < RECORDSIZE; j++) {
      data = readDataByte(i + j);
      printByte(data);
      sumCheckCount -= data;
    }
    printByte(sumCheckCount);
    Serial.println();
  }
  clearPins();
}

void generateEndRecord() {
  Serial.println(":00000001FF");
}

void errorLed() {
  char *parseBuf = &serialBuffer[2];

  if (parseBuf[0] == '1') { // LED on
    pinMode(errorPin, OUTPUT);
    digitalWrite(errorPin, LOW); 
  } else {                  // LED off
    pinMode(errorPin, INPUT);
    digitalWrite(errorPin, HIGH); 
  }
}

void clearSerialBuffer() {
  byte i;
  for (i = 0; i < SERIALBUFSIZE; i++) {
    serialBuffer[i] = 0;
  }
}

void clearPins() {
    for (int i = 0; i < promDataPinCount; i++) {
        pinMode(promDataPins[i], INPUT_PULLUP);
    }
    for (int i = 0; i < promAddrPinCount; i++) {
        pinMode(promAddrPins[i], INPUT_PULLUP);
    }
    for (int i = 0; i < promSelectPinCount; i++) {
        pinMode(promSelectPins[i], INPUT_PULLUP);
    }
}

byte readDataByte(int addr) {
    setAddr((uint8_t)addr);
    byte data = 0;
    bool bit;
    for (int d = 0; d < promDataPinCount; d++) {
        bit = digitalRead(promDataPins[d]);
        data += bit ? (1 << d) : 0;
    }
    return data;
}

void setAddr(uint8_t addr) {
    uint8_t bitMask;
    bool bitValue;
    for (uint8_t a = 0; a < promAddrPinCount; a++) {
        bitMask = 1 << a;
        bitValue = (addr & bitMask) ? 1 : 0;
        digitalWrite(promAddrPins[a], bitValue);
    }
}

void printByte(unsigned char data) {
  unsigned char dataMSN = data >> 4;
  unsigned char dataLSN = data & 0x0F;
  Serial.print(dataMSN, HEX);
  Serial.print(dataLSN, HEX);
}

void printWord(unsigned int data) {
  printByte(data >> 8);
  printByte(data & 0xFF);
}

void enableVcc() {
    digitalWrite(power20, LOW);
    pinMode(power20, OUTPUT);
}

void disableVcc() {
    digitalWrite(power20, HIGH);
    pinMode(power20, INPUT);
}

void setAddrBusOutput() {
   for (int i = 0; i < promAddrPinCount; i++) {
      pinMode(promAddrPins[i], OUTPUT);
   }
}

void chipSelect() {
    for (int i = 0; i < promSelectPinCount; i++) {
        pinMode(promSelectPins[i], OUTPUT);
        digitalWrite(promSelectPins[i], LOW);
    }
}
