#!/usr/bin/python3
#
# uploader.py - uploads files over a serial line with some delays.
#               tuned for the SPC16/10 SBC board from Jos Dreesen
#               https://github.com/josdreesen/SPC16_SBC
#
# fjkraan@electrickery.nl, 2025-11-06

import sys
import serial
import time

port = '/dev/ttyACM0'  # default port

if len(sys.argv) == 1:
   print("Usage: python uploader.py <hexFile> [<ttyPort>]")
   exit()
if len(sys.argv) > 1:
    hexFile = sys.argv[1]
if len(sys.argv) > 2:
    port = sys.argv[2]

LF = "\r\n"
sendDelay = 0.005
time.sleep(sendDelay)

ser = serial.Serial(port, 19200, timeout=0)  # open serial port

print("Uploading " + hexFile + " to " + port)

file = open(hexFile, 'r')
lines = file.readlines()
file.close()

time.sleep(sendDelay)

for line in lines:
    lineStrip = line.strip()
    if (lineStrip):
        for char in lineStrip:
            ser.write(str.encode(char))
            time.sleep(sendDelay)
        ser.write(str.encode(LF))

ser.close()
